%
% Use daily financial market data to help fill in current month values.
%  By incorporating daily data for the current month, we should be able to
%  obtain a better forecast of all data and factors in the current month
%  and give ourselves a better jumping-off point for the forecast going
%  forward.
%

headrowsd = 3 ;

% load daily data
[datad,txtd,rawd] = xlsread(infilestr,'Daily') ;
datesd = str2num(cell2mat(txtd(headrowsd+1:size(txtd,1),2))) ;
datesd = [floor(datesd/10000) mod(floor(datesd/100),100) mod(datesd,100)] ;

% find all daily data that lie in current month:
iend = size(dates,1) ;
i = find(datesd(:,1)==dates(iend,1) & datesd(:,2)==dates(iend,2)) ;

if (length(i)>=3) ; % do not use current month data unless we have >=3 days' worth
  j = i(end-2:end,:) ; % three most recent values for current month
  curmthrec = robustmean(datad(j,:)) ;
  curmthavg = (length(i)/21.5) * robustmean(datad(i,:)) + ...
                                            (1-length(i)/21.5) * curmthrec ;
  for k = 1:size(datad,2) ;
    updatemnem = char(rawd(headrowsd-1,2+k)) ; % Haver mnemonic for series to update
    updateindex(k) = find(strcmp(raw(3,3:end),updatemnem)) ;
  end ;

  endindexes = strcmp(rawd(1,3:end),'END') ;

  if (iend>size(data,1)); data(iend,:) = NaN; end ; % early in mth there may be no other time T observable data
  data(iend,updateindex(endindexes)) = curmthrec(endindexes) ; % set current month = recent data
  data(iend,updateindex(~endindexes)) = curmthavg(~endindexes) ; % set current-month = avg data
end ;

